IF EXISTS ( SELECT * FROM SYS.OBJECTS WHERE TYPE = 'TR' AND name = 'CT_Cbtes_Items_CD_Clientes_Novedades_Ins')
BEGIN
    DROP TRIGGER dbo.CT_Cbtes_Items_CD_Clientes_Novedades_Ins 
END
GO

CREATE TRIGGER [dbo].[CT_Cbtes_Items_CD_Clientes_Novedades_Ins] ON [dbo].[Cbtes_Items]
AFTER INSERT
AS 
SET NOCOUNT ON
DECLARE @Id_Trans					INT
DECLARE @Item						SMALLINT
DECLARE @Id_Novedad_Pendiente		INT
DECLARE @Id_Cliente					INT
DECLARE @xParam_CD_Cli_Noved_Ejecut	INT

--INSERT (Sobre Cbtes_Items) y UPDATE (Cbtes) estan separados los Trigger porque en Clarion mantiene todo en Memoria y luego graba todo junto.

SET @xParam_CD_Cli_Noved_Ejecut = ISNULL(CONVERT(INT, dbo.CF_xParam('CD_Cli_Noved_Ejecut')), 0)

IF (@xParam_CD_Cli_Noved_Ejecut <> 0)
BEGIN
	SET NOCOUNT ON
	DECLARE cur_CT_Cbtes_Items_CD_Clientes_Novedades_Ins CURSOR FOR
	SELECT I.Id_Trans, I.Item, ISNULL(I.Id_Cliente, 0)
	FROM Inserted I, Cbtes CB, Cbtes_Tipos CT
	WHERE
	I.Id_Trans = CB.Id_Trans
	AND ISNULL(CB.Id_Tipo_Cbte, '')  = CT.Id_Tipo_Cbte
	AND ISNULL(CT.Compromete_Factura, 0) IN (1,-1)

	OPEN cur_CT_Cbtes_Items_CD_Clientes_Novedades_Ins
	FETCH NEXT FROM cur_CT_Cbtes_Items_CD_Clientes_Novedades_Ins INTO @Id_Trans, @Item, @Id_Cliente
	WHILE @@FETCH_STATUS = 0
	BEGIN
		
		SET @Id_Novedad_Pendiente = ISNULL(	(SELECT MAX(Id_Novedad)
											FROM CD_Clientes_Novedades
											WHERE
											Estado = 'P'
											AND Id_Cliente = @Id_Cliente)
											, 0)
		IF(@Id_Novedad_Pendiente > 0)
		BEGIN
			UPDATE CD_Clientes_Novedades
			SET
			Fecha = GETDATE()
			WHERE
			Estado = 'P'
			AND Id_Cliente = @Id_Cliente
		END
		ELSE
		BEGIN
			INSERT INTO CD_Clientes_Novedades
			(Id_Cliente,		Fecha,		Estado)
			VALUES
			(@Id_Cliente,		GETDATE(),	'P')
		END
		  
		FETCH NEXT FROM cur_CT_Cbtes_Items_CD_Clientes_Novedades_Ins INTO @Id_Trans, @Item, @Id_Cliente
	END
	CLOSE cur_CT_Cbtes_Items_CD_Clientes_Novedades_Ins
	DEALLOCATE cur_CT_Cbtes_Items_CD_Clientes_Novedades_Ins
END